/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.datagen;

import com.rcx.materialis.MaterialisResources;
import com.rcx.materialis.datagen.MaterialisMaterials;
import com.rcx.materialis.datagen.MaterialisModifiers;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.StaticModifier;

public class MaterialisLang
extends LanguageProvider {
    public MaterialisLang(DataGenerator gen) {
        super(gen, "materialis", "en_us");
    }

    protected void addTranslations() {
        for (MaterialisResources.FluidWithBlockNBucket fluid : MaterialisResources.fluidList) {
            this.addBlock((Supplier)fluid.FLUID_BLOCK, fluid.localizedName);
            this.addFluid((Supplier<? extends ForgeFlowingFluid>)fluid.FLUID, fluid.localizedName);
            this.addItem((Supplier)fluid.FLUID_BUCKET, fluid.localizedName + " Bucket");
        }
        for (MaterialisResources.IngotWithBlockNNugget material : MaterialisResources.materialList) {
            this.addBlock((Supplier)material.BLOCK, material.localizedName + " Block");
            this.addItem((Supplier)material.INGOT, material.localizedName + " Ingot");
            this.addItem((Supplier)material.NUGGET, material.localizedName + " Nugget");
        }
        this.addMaterial(MaterialisMaterials.fairy, "Fairy", "From the fairy depths of hell.", "Adds the percentage of health lost multiplied by the level to your mining speed");
        this.add("tooltip.materialis.stored_enegry", "Energy: %s / %s RF");
        this.addCast(MaterialisResources.INLAY_CAST, "Inlay");
        this.addCast(MaterialisResources.WRENCH_HEAD_CAST, "Wrench Head");
        this.addItem((Supplier)MaterialisResources.WRENCH_HEAD, "Wrench Head");
        this.add("pattern.materialis.wrench_head", "Wrench Head");
        this.addItem((Supplier)MaterialisResources.WRENCH, "Wrench");
        this.add("item.materialis.wrench.description", "The Wrench is a common tool among engineers. It can efficiently break machines and has room for many abilities.\nRight Click: Rotate block");
        this.addItem((Supplier)MaterialisResources.BATTLEWRENCH, "Battlewrench");
        this.add("recipe.materialis.modifier.thermal_wrenching_requirements", "Thermal Wrenching requires Wrenching to apply");
        this.add("recipe.materialis.modifier.create_wrenching_requirements", "Mechanical Wrenching requires Wrenching to apply");
        this.add("recipe.materialis.modifier.immersive_wrenching_requirements", "Immersive Hammering requires Wrenching to apply");
        this.add("recipe.materialis.modifier.pipe_wrenching_requirements", "Pipe Wrenching requires Wrenching to apply");
        this.addMaterial(MaterialisMaterials.brass, "Brass", "Ya like brass?", "Adds +1.5 attack damage per level that degrades as durability goes down");
        this.addMaterial(MaterialisMaterials.aluminum, "Aluminum", "", "-10% attack damage, +15% attack speed per level");
        this.addMaterial(MaterialisMaterials.nickel, "Nickel", "", "Adds half a second of burning per level to targets that are on fire");
        this.addMaterial(MaterialisMaterials.uranium, "Uranium", "", "Tool takes up to twice as much durability damage when above a quarter durability and increasingly less damage below a quarter durability");
        this.addMaterial(MaterialisMaterials.roseQuartz, "Rose Quartz", "Disclaimer: Not actually made with roses.", "Grants 1 extra upgrade slot per part");
        this.addMaterial(MaterialisMaterials.refinedRadiance, "Refined Radiance", "", "Applies 20 seconds of glowing to attacked mobs and leaves a glowing air block when a block is mined that despawns eventually");
        this.add("material.materialis.refined_radiance.format", "Radiant %s");
        this.addMaterial(MaterialisMaterials.shadowSteel, "Shadow Steel", "", "Voids all dropped items from mob kills and broken blocks, drops bonus xp instead");
        this.addMaterial(MaterialisMaterials.pewter, "Pewter", "", "-5% attack speed, +10% attack damage per level");
        this.addMaterial(MaterialisMaterials.arcaneGold, "Arcane Gold", "", "+1 magic damage per level");
        this.addMaterial(MaterialisMaterials.neptunium, "Neptunium", "", "1.25x damage to submerged mobs, no mining speed penalty when underwater");
        this.addMaterial(MaterialisMaterials.quicksilver, "Quicksilver", "", "Tool no longer takes durability damage from usages but has a 1% chance of losing durability every second");
        this.addMaterial(MaterialisMaterials.starmetal, "Starmetal", "Not to be confused with star cutting metal.", "Tool gains 2 mining speed per level at midnight");
        this.addMaterial(MaterialisMaterials.plastic, "Plastic", "", "-20% knockback per level");
        this.addMaterial(MaterialisMaterials.pinkSlime, "Pink Slime", "Do you have any idea where that's been?", "Overslime can be eaten to restore 1 hunger and 0.1 saturation per level");
        this.addMaterial(MaterialisMaterials.pinkSlimeball, "Pink Slime", "", "");
        this.addMaterial(MaterialisMaterials.cloggrum, "Cloggrum", "", "Repairing the tool costs up to half as much the higher the durability the tool has");
        this.addMaterial(MaterialisMaterials.froststeel, "Froststeel", "", "Applies 7.5 seconds of slowness to attacked mobs per level");
        this.addMaterial(MaterialisMaterials.utherium, "Utherium", "", "Deals 25% extra damage to rotspawn per level");
        this.addMaterial(MaterialisMaterials.regalium, "Regalium", "", "");
        this.addMaterial(MaterialisMaterials.forgottenMetal, "Forgotten Metal", "It's the uhhh umm, y- I uhhhh ermmmm...", "Deals 50% extra damage to undergarden mobs per level, +25% mining speed on undergarden blocks per level");
        this.add("material.materialis.forgotten_metal.format", "Forgotten %s");
        this.addMaterial(MaterialisMaterials.refinedObsidian, "Refined Obsidian", "", "-20% reach");
        this.addMaterial(MaterialisMaterials.refinedGlowstone, "Refined Glowstone", "", "Adds the mining speed, multiplied by the level, divided by 80, to the attack speed");
        this.addMaterial(MaterialisMaterials.psimetal, "Psimetal", "", "Casts the selected spell on block break for tools and on attack for weapons, also adds one spell socket");
        this.addMaterial(MaterialisMaterials.ebonyPsimetal, "Ebony Psimetal", "", "Adds up to 1 extra attack damage that scales with the amount of psi you have per level");
        this.addMaterial(MaterialisMaterials.ivoryPsimetal, "Ivory Psimetal", "", "Adds up to 1 extra mining speed that scales with the amount of psi you have per level");
        this.add("recipe.materialis.remove_modifier.spell_slot_not_empty", "This change removes a socket that currently contains a spell");
        this.add("recipe.materialis.add_modifier.too_many_spell_slots", "This change adds too many sockets to the tool");
        this.add("recipe.materialis.modifier.casting_requirements", "Casting requires Psionizing Radiation or Psi Decay to apply");
        this.add("stat.tconstruct.slot.display.sensor", "sensor");
        this.add("stat.tconstruct.slot.prefix.sensor", "Sensor Slots: ");
        this.add("item.tconstruct.creative_slot.sensor", "Creative Sensor Slot");
        this.add("recipe.materialis.modifier.runed_requirements", "Runed requires Shiny to apply");
        this.addMaterial(MaterialisMaterials.iesnium, "Iesnium", "", "Allows the tool to harvest otherworld blocks");
        this.addMaterial(MaterialisMaterials.livingwood, "Livingwood", "", "increases attack damage with 1.5 per level, mana cost increases with level");
        this.addMaterial(MaterialisMaterials.dreamwood, "Dreamwood", "", "increases mining speed with 2.5 per level, mana cost increases with level");
        this.addMaterial(MaterialisMaterials.manasteel, "Manasteel", "", "Has a 10% chance of using mana instead of durability per level");
        this.addMaterial(MaterialisMaterials.elementium, "Elementium", "", "Adds a 3% chance to spawn a pixie while holding the tool per level");
        this.addMaterial(MaterialisMaterials.terrasteel, "Terrasteel", "", "Has a 40% chance per level to fire a beam, this costs mana or durability if you have no mana");
        this.addMaterial(MaterialisMaterials.alfsteel, "Alfsteel", "", "Has a 40% chance per level to fire a beam, this costs mana or durability if you have no mana");
        this.addMaterial(MaterialisMaterials.draconium, "Draconium", "", "Has a 10% chance of using 200 RF instead of durability per level");
        this.add("material.materialis.draconium.format", "Wyvern %s");
        this.addMaterial(MaterialisMaterials.awakenedDraconium, "Awakened Draconium", "", "increases mining speed with 2.5 and attack damage with 1.5 per level, costs 100 RF per level");
        this.add("material.materialis.draconium_awakened.format", "Draconic %s");
        this.addMaterial(MaterialisMaterials.fluxInfused, "Flux-Infused", "", "increases mining speed with 2.5 and attack damage with 1.5 per level, costs 100 RF per level");
        this.addModifier(MaterialisModifiers.enhancedQuartzModifier, "Enhanced", "Shiny!", "Rose quartz goes great with a bonus upgrade!");
        this.addModifier(MaterialisModifiers.voidingModifier, "Voiding", "Forged in the void", "Voids block and mob drops, drops extra experience instead");
        this.addModifier(MaterialisModifiers.residualLightModifier, "Residual Light", "Forged from light", "Leaves behind pieces of light (photons) when hitting mobs leaving them glowing or when breaking blocks leaving the air glowing for some time");
        this.addModifier(MaterialisModifiers.inertiaModifier, "Inertia", "A property of matter", "Decreases attack speed but increases attack damage");
        this.addModifier(MaterialisModifiers.featherweightModifier, "Featherweight", "Beep beep", "Decreases attack damage but increases attack speed");
        this.addModifier(MaterialisModifiers.arcaneModifier, "Arcane", "Magic *snort*", "Deals a small amount of extra magic damage to attacked targets");
        this.add("modifier.materialis.arcane.attack_damage", "Magic Damage");
        this.addModifier(MaterialisModifiers.reapingModifier, "Reaping", "Harvester of souls", "Killing undead mobs will destroy their bodies and crystallize their souls, seems to have an affection towards scythes");
        this.addModifier(MaterialisModifiers.neptunesBlessingModifier, "Neptune's Blessing", "Stay hydrated", "Increases damage to submerged mobs and allows you to mine normally while swimming");
        this.addModifier(MaterialisModifiers.halfLifeModifier, "Half-Life", "Smell the ashes", "Your tool loses durability faster when it has high durability and loses durability slower when it has low durability");
        this.add("modifier.materialis.half_life.3", "Half-Life II: Episode I");
        this.add("modifier.materialis.half_life.4", "Half-Life II: Episode II");
        this.addModifier(MaterialisModifiers.workHardenedModifier, "Work Hardened", "Play hardeneder", "Your tool loses durability slower when it has low durability");
        this.addModifier(MaterialisModifiers.daredevilModifier, "Daredevil", "Living on the edge", "Boosts mining speed when your health is low");
        this.addModifier(MaterialisModifiers.polishedModifier, "Polished", "I can see my face in it!", "Deals more damage at a higher durability");
        this.add("modifier.materialis.polished.attack_damage", "Polished Attack Damage");
        this.addModifier(MaterialisModifiers.decayModifier, "Decay", "Also melts in your hands", "Your tool doesn't use durability on use but instead decays over time");
        this.addModifier(MaterialisModifiers.nocturnalModifier, "Nocturnal", "Stay up past bedtime!", "gives bonus mining speed during the night, most powerful at midnight");
        this.add("modifier.materialis.nocturnal.mining_speed", "Mining Speed at midnight");
        this.addModifier(MaterialisModifiers.feebleModifier, "Feeble", "Handle with care", "Decreases knockback on attacked mobs");
        this.addModifier(MaterialisModifiers.overweightModifier, "Overweight", "Supersized!", "Eats some mining speed and attack damage to gain more overslime capacity");
        this.addModifier(MaterialisModifiers.economicalModifier, "Economical", "Waste not, want not", "Repairing your tool is cheaper when your tool has low durability");
        this.addModifier(MaterialisModifiers.oldTimerModifier, "Old-Timer", "Rust bucket!", "Repairing your tool is more expensive when your tool has high durability");
        this.addModifier(MaterialisModifiers.freezingModifier, "Freezing", "As cold as ice!", "Slows down hit mobs");
        this.addModifier(MaterialisModifiers.cleansingModifier, "Cleansing", "Begone foul beast!", "Deals more damage to rotspawn");
        this.addModifier(MaterialisModifiers.underlordModifier, "Underlord", "Master of the Undergarden", "Deals more damage to non-boss undergarden mobs and mines undergarden blocks faster");
        this.addModifier(MaterialisModifiers.shortSightedModifier, "Short-Sighted", "Do now, think later", "Decreases your reach distance");
        this.addModifier(MaterialisModifiers.auxiliaryPowerModifier, "Auxiliary Power", "Extra juice!", "Boosts your attack speed based on your mining speed");
        this.addModifier(MaterialisModifiers.adrenalineModifier, "Adrenaline", "Fight or flight!", "Boosts attack damage when your health is low");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifier, "Psionizing Radiation", "Feels kinda funny", "Your tool is highly conductive to psions and is suitable for casting spells, +1 spell socket");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierBreakBlock, "Psi Decay (Break Block)", "You can feel it glowing", "Enables the tool to cast spells when breaking blocks");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierAttack, "Psi Decay (Attack)", "You can feel it glowing", "Enables the tool to cast spells when attacking");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierDamage, "Psi Decay (Damage)", "You can feel it glowing", "Enables the tool to cast spells when taking damage");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierTick, "Psi Decay (Tick)", "You can feel it glowing", "Enables the tool to cast spells every tick");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierJump, "Psi Decay (Jump)", "You can feel it glowing", "Enables the tool to cast spells when jumping");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierFire, "Psi Decay (On Fire)", "You can feel it glowing", "Enables the tool to cast spells when taking fire damage");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierHealth, "Psi Decay (Low Health)", "You can feel it glowing", "Enables the tool to cast spells when your health is low");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierLight, "Psi Decay (Low Light)", "You can feel it glowing", "Enables the tool to cast spells when entering darkness");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierWater, "Psi Decay (Underwater)", "You can feel it glowing", "Enables the tool to cast spells when underwater");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierDetonate, "Psi Decay (Detonation)", "You can feel it glowing", "Enables the tool to cast spells when a spell is detonated nearby");
        this.addModifier(MaterialisModifiers.lesserPsionizingRadiationModifier, "Psi Decay", "You can feel it glowing", "Your tool is highly conductive to psions and is suitable for casting spells");
        this.addModifier(MaterialisModifiers.spellSocketModifier, "Socket", "More durable than lime sockets!", "Adds one psi spell socket to your tool");
        this.addModifier(MaterialisModifiers.spellCastingModifier, "Casting", "Doesn't involve molten metal", "Adds the ability to cast spells on right-click but removes the ability to cast spells on block breaking and attacking, +1 spell socket");
        this.addModifier(MaterialisModifiers.lesserSpellCastingModifier, "Casting", "Doesn't involve molten metal", "Adds the ability to cast spells on right-click but removes the ability to cast spells on block breaking and attacking");
        this.addModifier(MaterialisModifiers.colorizedModifier, "Colorized", "Colormatic!", "Adds a decorative colorizer to your tool");
        this.addModifier(MaterialisModifiers.psionizingRadiationModifierSensor, "Sensor", "6th sense!", "Enables the tool to cast spells when the selected sensor is triggered");
        this.addModifier(MaterialisModifiers.psichoKillerModifier, "Psicho Killer", "Qu'est-ce que c'est?", "Deals bonus attack damage depending on how much psi you currently have");
        this.add("modifier.materialis.psicho_killer.attack_damage", "Attack Damage at full Psi");
        this.addModifier(MaterialisModifiers.psichoDiggerModifier, "Psicho Digger", "Run run run away", "Adds bonus mining speed depending on how much psi you currently have");
        this.add("modifier.materialis.psicho_digger.mining_speed", "Mining Speed at full Psi");
        this.addModifier(MaterialisModifiers.runedModifier, "Runed", "Runic energy flows!", "Tool glows with a colored enchantment glint");
        this.addModifier(MaterialisModifiers.brittleModifier, "Brittle", "Disintegrates into chalk", "Tool takes much more durability damage");
        this.addModifier(MaterialisModifiers.refuelingModifier, "Refueling", "Feed the fire", "Attacked mobs that are on fire will burn for longer");
        this.addModifier(MaterialisModifiers.quenchingModifier, "Quenching", "Uninflammable!", "Extinguishes mobs and deals bonus damage depending on how much longer the mob would have burned");
        this.add("modifier.materialis.otherworldly", "Otherworldly");
        this.add("modifier.materialis.otherworldly.flavor", "From another plane of existence!");
        this.add("modifier.materialis.otherworldly.description", "Allows the tool to harvest blocks from The Other Place");
        this.addModifier(MaterialisModifiers.wrenchingModifier, "Wrenching", "Wretched!", "Tool can rotate blocks by right clicking");
        this.addModifier(MaterialisModifiers.galvanizedModifier, "Galvanized", "Stainless!", "Trades two upgrade slots for an ability slot");
        this.addModifier(MaterialisModifiers.thermalWrenchingModifier, "Thermal Wrenching", "Crescent!", "Tool can dismantle thermal machines by sneak-right clicking");
        this.addModifier(MaterialisModifiers.createWrenchingModifier, "Mechanical Wrenching", "Creative!", "Tool can dismantle kinetic components by sneak-right clicking");
        this.addModifier(MaterialisModifiers.immersiveWrenchingModifier, "Immersive Hammering", "Pootis spencer here!", "Tool can assemble multiblocks and configure sides of certain blocks");
        this.addModifier(MaterialisModifiers.pipeWrenchingModifier, "Pipe Wrenching", "Pretty!", "Tool can configure pretty pipes");
        this.addModifier(MaterialisModifiers.overeatingModifier, "Overeating", "5 second rule!", "That overslime buffer on your tool suddenly looks very appealing");
        this.addModifier(MaterialisModifiers.psishieldModifier, "Psishield", "Psichological!", "Has a chance of protecting your tool from damage at the cost of psi");
        this.addModifier(MaterialisModifiers.manaripperModifier, "Manaripper", "Rip and tear", "Boosts attack damage at the cost of mana");
        this.add("modifier.materialis.manaripper.attack_damage", "Attack Damage with Mana");
        this.addModifier(MaterialisModifiers.manaburnerModifier, "Manaburner", "burn through the mana", "Boosts mining speed at the cost of mana");
        this.add("modifier.materialis.manaburner.mining_speed", "Mining Speed with Mana");
        this.addModifier(MaterialisModifiers.manashieldModifier, "Manashield", "Botanical!", "Has a chance of protecting your tool from damage at the cost of mana");
        this.addModifier(MaterialisModifiers.pixiecallerModifier, "Pixiecaller", "Pix or it didn't happen", "Has a chance of spawning a pixie when you take damage while holding the tool");
        this.addModifier(MaterialisModifiers.terrabeamModifier, "Terrabeam", "Beam me up!", "When attacking with your tool you have a chance of firing a beam of mana");
        this.addModifier(MaterialisModifiers.elvenBeamModifier, "Elven Beam", "Science cannot yet explain how it works", "When attacking with your tool you have a chance of firing a beam of mana");
        this.addModifier(MaterialisModifiers.capacitorModifier, "Capacitor", "This is what makes time travel possible, the flux capacitor", "Increases the energy capacity of the tool by 10000");
        this.addModifier(MaterialisModifiers.fluxripperModifier, "Fluxripper", "64 cores!", "Boosts attack damage at the cost of energy");
        this.add("modifier.materialis.fluxripper.attack_damage", "Fluxed Attack Damage");
        this.addModifier(MaterialisModifiers.fluxburnerModifier, "Fluxburner", "Empowered!", "Boosts mining speed at the cost of energy");
        this.add("modifier.materialis.fluxburner.mining_speed", "Fluxed Mining Speed");
        this.addModifier(MaterialisModifiers.fluxshieldModifier, "Fluxshield", "Energized!", "Has a chance of protecting your tool from damage at the cost of energy");
        this.addModifier(MaterialisModifiers.powerHungryModifier, "Power Hungry", "Megalomaniac!", "Using the tool costs 100 RF per durability per level, the tool doesn't seem to work so well if it's not powered");
        this.addModifier(MaterialisModifiers.engineersGogglesModifier, "Engineers Goggles", "Mind-goggling", "Shows additional information when looking at kinetic devices");
        this.addModifier(MaterialisModifiers.otherworldGogglesModifier, "Otherworld Goggles", "Open your third eye", "Allows you to see blocks from the other place, can be toggled with sneak + helmet interact");
        this.addModifier(MaterialisModifiers.reactiveModifier, "Reactive", "Not to be confused with radioactive", "Has a chance to cast the inscribed spell on use");
        this.add("recipe.materialis.modifier.reactive_requirements", "Reactive requires a different recipe for every level");
    }

    public void addFluid(Supplier<? extends ForgeFlowingFluid> key, String name) {
        ResourceLocation id = key.get().getRegistryName();
        this.add("fluid." + id.m_135827_() + "." + id.m_135815_(), name);
    }

    public void addCast(CastItemObject cast, String name) {
        ResourceLocation id = ((Item)cast.get()).getRegistryName();
        this.add("item." + id.m_135827_() + "." + id.m_135815_(), name + " Gold Cast");
        ResourceLocation idSand = cast.getSand().getRegistryName();
        this.add("item." + idSand.m_135827_() + "." + idSand.m_135815_(), name + " Sand Cast");
        ResourceLocation idRedSand = cast.getRedSand().getRegistryName();
        this.add("item." + idRedSand.m_135827_() + "." + idRedSand.m_135815_(), name + " Red Sand Cast");
    }

    public void addMaterial(MaterialId material, String name, String flavour, String desc) {
        String id = material.m_135815_();
        this.add("material.materialis." + id, name);
        if (!flavour.equals("")) {
            this.add("material.materialis." + id + ".flavor", flavour);
        }
        if (!desc.equals("")) {
            this.add("material.materialis." + id + ".encyclopedia", desc);
        }
    }

    public void addModifier(StaticModifier<? extends Modifier> modifier, String name, String flavour, String desc) {
        String id = modifier.getId().m_135815_();
        this.add("modifier.materialis." + id, name);
        this.add("modifier.materialis." + id + ".flavor", flavour);
        this.add("modifier.materialis." + id + ".description", desc);
    }

    public void addModifier(ModifierId modifier, String name, String flavour, String desc) {
        String id = modifier.m_135815_();
        this.add("modifier.materialis." + id, name);
        this.add("modifier.materialis." + id + ".flavor", flavour);
        this.add("modifier.materialis." + id + ".description", desc);
    }
}

